<?php
	$widget_id = $this->get_id();
	
	//Get all settings
	$settings = $this->get_settings();
	
	$redirect_to_page = get_site_url();
	if(!empty($settings['redirect_page']))
	{
		$redirect_to_page = get_the_permalink($settings['redirect_page']);
	}
	
	$keyword = '';
	if(isset($_GET['s']))
	{
		$keyword = $_GET['s'];
	}
?>
<div class="tg_search_wrapper"> 	
	<form id="tg_search_form_<?php echo esc_attr($widget_id); ?>" class="tg_search_form <?php if($settings['autocomplete'] == 'yes') { ?>autocomplete_form<?php } ?>" method="get" action="<?php echo esc_url($redirect_to_page); ?>" data-result="autocomplete_<?php echo esc_attr($widget_id); ?>" data-course="<?php echo esc_attr($settings['search_lp_course']); ?>">
		<div class="input_group">
			<input name="s" placeholder="<?php echo esc_attr($settings['placeholder']); ?>" autocomplete="off" value="<?php echo esc_attr($keyword); ?>"/>
			<?php
				if($settings['autocomplete'] == 'yes')
				{
			?>
				<div id="autocomplete_<?php echo esc_attr($widget_id); ?>" class="autocomplete" data-mousedown="false"></div>
		    <?php
			    }
			    
			    if (function_exists('icl_object_id')) {
			?>
			    <input id="lang" name="lang" type="hidden" value="<?php echo esc_attr(ICL_LANGUAGE_CODE); ?>"/>
			<?php
				}
			?>
			<span class="input_group_button">
				<button aria-label="<?php echo esc_attr($settings['placeholder']); ?>" type="submit"><span class="ti-search"></span></button>
			</span>
		</div>
	</form>
</div>