<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Coursector_Templates_Source extends Elementor\TemplateLibrary\Source_Base {

	/**
	 * Template prefix
	 *
	 * @var string
	 */
	protected $template_prefix = 'coursector_';

	/**
	 * Return templates prefix
	 *
	 * @return [type] [description]
	 */
	public function get_prefix() {
		return $this->template_prefix;
	}

	public function get_id() {
		return 'coursector-templates';
	}

	public function get_title() {
		return __( 'Coursector Templates', 'coursector-elementor' );
	}

	public function register_data() {}

	public function get_items( $args = array() ) {
		
		$templates = array();

		$templates_data = array(
			1 	=> array(
				'template_id'      	=> $this->template_prefix .'1',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Home 1',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_1.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'page',
				'subtype'			=> 'page',
				'author'            => 'ThemeGoods',

				'keywords'          => array('home'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/',
			),
			2 	=> array(
				'template_id'      	=> $this->template_prefix .'2',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Home 2',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_2.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'page',
				'subtype'			=> 'page',
				'author'            => 'ThemeGoods',

				'keywords'          => array('home'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/home-2/',
			),
			3 	=> array(
				'template_id'      	=> $this->template_prefix .'3',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Home 3',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_3.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'page',
				'subtype'			=> 'page',
				'author'            => 'ThemeGoods',

				'keywords'          => array('home'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/home-3/',
			),
			4 	=> array(
				'template_id'      	=> $this->template_prefix .'4',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Home 4',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_4.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'page',
				'subtype'			=> 'page',
				'author'            => 'ThemeGoods',

				'keywords'          => array('home'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/home-4/',
			),
			5 	=> array(
				'template_id'      	=> $this->template_prefix .'5',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Home 5',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_5.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'page',
				'subtype'			=> 'page',
				'author'            => 'ThemeGoods',

				'keywords'          => array('home'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/home-5/',
			),
			6 	=> array(
				'template_id'      	=> $this->template_prefix .'6',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Home 6',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_6.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'page',
				'subtype'			=> 'page',
				'author'            => 'ThemeGoods',

				'keywords'          => array('home'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/home-6/',
			),
			7 	=> array(
				'template_id'      	=> $this->template_prefix .'7',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Home 7',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_7.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'page',
				'subtype'			=> 'page',
				'author'            => 'ThemeGoods',

				'keywords'          => array('home'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/home-7/',
			),
			8 	=> array(
				'template_id'      	=> $this->template_prefix .'8',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Home 8',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_8.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'page',
				'subtype'			=> 'page',
				'author'            => 'ThemeGoods',

				'keywords'          => array('home'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/home-8/',
			),
			9 	=> array(
				'template_id'      	=> $this->template_prefix .'9',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Home 9',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_9.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'page',
				'subtype'			=> 'page',
				'author'            => 'ThemeGoods',

				'keywords'          => array('home'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/home-9/',
			),
			10 	=> array(
				'template_id'      	=> $this->template_prefix .'10',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Home 10',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_10.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'page',
				'subtype'			=> 'page',
				'author'            => 'ThemeGoods',

				'keywords'          => array('home'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/home-10/',
			),
			11 	=> array(
				'template_id'      	=> $this->template_prefix .'11',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Home 11',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_11.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'page',
				'subtype'			=> 'page',
				'author'            => 'ThemeGoods',

				'keywords'          => array('home'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/home-11/',
			),
			12 	=> array(
				'template_id'      	=> $this->template_prefix .'12',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Home 12',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_12.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'page',
				'subtype'			=> 'page',
				'author'            => 'ThemeGoods',

				'keywords'          => array('home'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/home-12/',
			),
			13 	=> array(
				'template_id'      	=> $this->template_prefix .'13',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - About Us',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_13.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'page',
				'subtype'			=> 'page',
				'author'            => 'ThemeGoods',

				'keywords'          => array('about'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/about-us/',
			),
			14 	=> array(
				'template_id'      	=> $this->template_prefix .'14',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Contact',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_14.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'page',
				'subtype'			=> 'page',
				'author'            => 'ThemeGoods',

				'keywords'          => array('contact'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/contact/',
			),
			15 	=> array(
				'template_id'      	=> $this->template_prefix .'15',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Become a Teacher',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_15.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'page',
				'subtype'			=> 'page',
				'author'            => 'ThemeGoods',

				'keywords'          => array('teacher'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/become-teacher/',
			),
			16 	=> array(
				'template_id'      	=> $this->template_prefix .'16',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Course Categories',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_16.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'page',
				'subtype'			=> 'page',
				'author'            => 'ThemeGoods',

				'keywords'          => array('course'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/course-category/',
			),
			17 	=> array(
				'template_id'      	=> $this->template_prefix .'17',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Blog',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_17.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'page',
				'subtype'			=> 'page',
				'author'            => 'ThemeGoods',

				'keywords'          => array('blog'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog-grid/',
			),
			18 	=> array(
				'template_id'      	=> $this->template_prefix .'18',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Portfolio',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_18.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'page',
				'subtype'			=> 'page',
				'author'            => 'ThemeGoods',

				'keywords'          => array('portfolio'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/portfolio-timeline-vertical/',
			),
			19 	=> array(
				'template_id'      	=> $this->template_prefix .'19',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Video Grid',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_19.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'page',
				'subtype'			=> 'page',
				'author'            => 'ThemeGoods',

				'keywords'          => array('video'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/video-grid/',
			),
			20 	=> array(
				'template_id'      	=> $this->template_prefix .'20',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Single Portfolio',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_20.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'page',
				'subtype'			=> 'page',
				'author'            => 'ThemeGoods',

				'keywords'          => array('portfolio'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/single-portfolio/',
			),
						
			//Adding navigation menu block templates
			501 => array(
				'template_id'      	=> $this->template_prefix .'501',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Header 1',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_501.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme navigation menu',
				'author'            => 'ThemeGoods',

				'keywords'          => array('navigation'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/header/header-1/',
			),
			502 => array(
				'template_id'      	=> $this->template_prefix .'502',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Header 2',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_502.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme navigation menu',
				'author'            => 'ThemeGoods',

				'keywords'          => array('navigation'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/header/header-2/',
			),
			503 => array(
				'template_id'      	=> $this->template_prefix .'503',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Header 3',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_503.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme navigation menu',
				'author'            => 'ThemeGoods',

				'keywords'          => array('navigation'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/header/header-3/',
			),
			504 => array(
				'template_id'      	=> $this->template_prefix .'504',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Header 4',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_504.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme navigation menu',
				'author'            => 'ThemeGoods',

				'keywords'          => array('navigation'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/header/header-4/',
			),
			505 => array(
				'template_id'      	=> $this->template_prefix .'505',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Header 5',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_505.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme navigation menu',
				'author'            => 'ThemeGoods',

				'keywords'          => array('navigation'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/header/header-5/',
			),
			506 => array(
				'template_id'      	=> $this->template_prefix .'506',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Header 6',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_506.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme navigation menu',
				'author'            => 'ThemeGoods',

				'keywords'          => array('navigation'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/header/header-6/',
			),
			508 => array(
				'template_id'      	=> $this->template_prefix .'508',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Header 8',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_508.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme navigation menu',
				'author'            => 'ThemeGoods',

				'keywords'          => array('navigation'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/header/header-8/',
			),
			509 => array(
				'template_id'      	=> $this->template_prefix .'509',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Header 9',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_509.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme navigation menu',
				'author'            => 'ThemeGoods',

				'keywords'          => array('navigation'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/header/header-9/',
			),
			510 => array(
				'template_id'      	=> $this->template_prefix .'510',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Header 10',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_510.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme navigation menu',
				'author'            => 'ThemeGoods',

				'keywords'          => array('navigation'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/header/header-10/',
			),
			511 => array(
				'template_id'      	=> $this->template_prefix .'511',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Header 11',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_511.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme navigation menu',
				'author'            => 'ThemeGoods',

				'keywords'          => array('navigation'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/header/header-11/',
			),
			512 => array(
				'template_id'      	=> $this->template_prefix .'512',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Header 12',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_512.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme navigation menu',
				'author'            => 'ThemeGoods',

				'keywords'          => array('navigation'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/header/header-12/',
			),
			
			//Adding mega menu block templates
			601 => array(
				'template_id'      	=> $this->template_prefix .'601',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Mega Menu Home Grid',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_601.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme mega menu',
				'author'            => 'ThemeGoods',

				'keywords'          => array('megamenu'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/megamenu/home-demos/',
			),
			602 => array(
				'template_id'      	=> $this->template_prefix .'602',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Mega Menu Course Categories',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_602.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme mega menu',
				'author'            => 'ThemeGoods',

				'keywords'          => array('megamenu'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/megamenu/course-categories/',
			),
			
			//Adding footer block templates
			701 => array(
				'template_id'      	=> $this->template_prefix .'701',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Footer 1',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_701.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme footer',
				'author'            => 'ThemeGoods',

				'keywords'          => array('footer'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/footer/footer-1/',
			),
			702 => array(
				'template_id'      	=> $this->template_prefix .'702',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Footer 2',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_702.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme footer',
				'author'            => 'ThemeGoods',

				'keywords'          => array('footer'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/footer/footer-2/',
			),
			703 => array(
				'template_id'      	=> $this->template_prefix .'703',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Footer 3',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_703.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme footer',
				'author'            => 'ThemeGoods',

				'keywords'          => array('footer'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/footer/footer-3/',
			),
			704 => array(
				'template_id'      	=> $this->template_prefix .'704',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Footer 4',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_704.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme footer',
				'author'            => 'ThemeGoods',

				'keywords'          => array('footer'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/footer/footer-4/',
			),
			705 => array(
				'template_id'      	=> $this->template_prefix .'705',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Footer 5',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_705.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme footer',
				'author'            => 'ThemeGoods',

				'keywords'          => array('footer'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/footer/footer-5/',
			),
			706 => array(
				'template_id'      	=> $this->template_prefix .'706',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Footer 6',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_706.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme footer',
				'author'            => 'ThemeGoods',

				'keywords'          => array('footer'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/footer/footer-6/',
			),
			708 => array(
				'template_id'      	=> $this->template_prefix .'708',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Footer 8',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_708.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme footer',
				'author'            => 'ThemeGoods',

				'keywords'          => array('footer'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/footer/footer-8/',
			),
			709 => array(
				'template_id'      	=> $this->template_prefix .'709',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Footer 9',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_709.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme footer',
				'author'            => 'ThemeGoods',

				'keywords'          => array('footer'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/footer/footer-9/',
			),
			710 => array(
				'template_id'      	=> $this->template_prefix .'710',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Footer 10',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_710.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme footer',
				'author'            => 'ThemeGoods',

				'keywords'          => array('footer'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/footer/footer-10/',
			),
			711 => array(
				'template_id'      	=> $this->template_prefix .'711',
				'source'            => $this->get_id(),
				'title'             => 'Coursector - Footer 11',
				'thumbnail'         => 'http://assets.themegoods.com/demo/coursector/templates/screenshots/coursector_711.png',
				'date'      		=> date( get_option( 'date_format' ), 1557992974 ),
				'type'				=> 'block',
				'subtype'			=> 'theme footer',
				'author'            => 'ThemeGoods',

				'keywords'          => array('footer'),
				'is_pro'            => false,
				'has_page_settings' => false,
				'url'               => 'https://themes.themegoods.com/coursector/blog/footer/footer-11/',
			),
		);
		
		if ( ! empty( $templates_data ) ) {
			foreach ( $templates_data as $template_data ) 
			{
				$templates_data['popularityIndex'] = 260;
				$templates_data['trendIndex'] = 125;
				
				$templates[] = $this->get_item( $template_data );
			}
		}

		if ( ! empty( $args ) ) {
			$templates = wp_list_filter( $templates, $args );
		}
		
		return $templates;
	}
	
	public function get_item( $template_data ) {
		return array(
			'template_id'     => $template_data['template_id'],
			'source'          => 'remote',
			'type'            => $template_data['type'],
			'subtype'         => $template_data['subtype'],
			'title'           => $template_data['title'],
			'thumbnail'       => $template_data['thumbnail'],
			'date'            => $template_data['date'],
			'author'          => $template_data['author'],
			'tags'            => $template_data['tags'],
			'isPro'           => ( 1 == $template_data['isPro'] ),
			'popularityIndex' => (int) $template_data['popularityIndex'],
			'trendIndex'      => (int) $template_data['trendIndex'],
			'hasPageSettings' => ( 1 == $template_data['hasPageSettings'] ),
			'url'             => $template_data['url'],
			'favorite'        => ( 1 == $template_data['favorite'] ),
		);
	}

	public function save_item( $template_data ) {
		return false;
	}

	public function update_item( $new_data ) {
		return false;
	}

	public function delete_template( $template_id ) {
		return false;
	}

	public function export_template( $template_id ) {
		return false;
	}

	public function get_data( array $args, $context = 'display' ) {
		$url	  = 'http://assets.themegoods.com/demo/coursector/templates/json/'.$args['template_id'].'.json';
		$response = wp_remote_get( $url, array( 'timeout' => 60 ) );
		$body     = wp_remote_retrieve_body( $response );
		$body     = json_decode( $body, true );
		$data     = ! empty( $body['content'] ) ? $body['content'] : false;
		
		$result = array();

		$result['content']       = $this->replace_elements_ids($data);
		$result['content']       = $this->process_export_import_content( $result['content'], 'on_import' );
		$result['page_settings'] = array();

		return $result;
	}
}
