<?php
if(!function_exists('coursector_get_course_price_html') && function_exists('learn_press_get_course'))
{	
	function coursector_get_course_price_html($course_id = '')
	{
		$price_html = '';
		if(!empty($course_id))
		{
			$course = learn_press_get_course($course_id);
			$price_html = $course->get_price_html();
		}
		
		return $price_html;
	}
}

if(!function_exists('coursector_highlight_keyword'))
{
	function coursector_highlight_keyword($str, $search) {
	    $occurrences = substr_count(strtolower($str), strtolower($search));
	    $newstring = $str;
	    $match = array();
	 
	    for ($i=0;$i<$occurrences;$i++) {
	        $match[$i] = stripos($str, $search, $i);
	        $match[$i] = substr($str, $match[$i], strlen($search));
	        $newstring = str_replace($match[$i], '[#]'.$match[$i].'[@]', strip_tags($newstring));
	    }
	 
	    $newstring = str_replace('[#]', '<strong>', $newstring);
	    $newstring = str_replace('[@]', '</strong>', $newstring);
	    return $newstring;
	}
}
	
if(!function_exists('coursector_sanitize_title'))
{
	function coursector_sanitize_title($title = '')
	{
		if(!empty($title))
		{
			$title = str_replace(' ', '-', $title);
			$title = preg_replace('/[^A-Za-z0-9]/', '-', $title);
			$title = strtolower($title);
			return $title;
		}
	}
}
	
if(!function_exists('coursector_get_lazy_img_attr'))
{
	function coursector_get_lazy_img_attr()
	{
		$tg_enable_lazy_loading = get_theme_mod('tg_enable_lazy_loading');
		$return_attr = array('class' => '','source' => 'src');
		
		if(!empty($tg_enable_lazy_loading))
		{
			$return_attr = array('class' => 'lazy','source' => 'data-src');
		}
		
		return $return_attr;
	}
}
	
if(!function_exists('coursector_get_blank_img_attr'))
{
	function coursector_get_blank_img_attr()
	{
		$tg_enable_lazy_loading = get_theme_mod('tg_enable_lazy_loading');
		$return_attr = '';
		
		if(!empty($tg_enable_lazy_loading))
		{
			$return_attr = 'src=""';
		}
		
		return $return_attr;
	}
}

if(!function_exists('coursector_get_post_format_icon'))
{
	function coursector_get_post_format_icon($post_id = '')
	{
		$return_html = '';
		
		if(!empty($post_id))
		{
			$post_format = get_post_format($post_id);
			
			if($post_format == 'video')
			{
				$return_html = '<div class="post_type_icon"><span class="ti-control-play"></span></div>';	
			}
		}
		
		return $return_html;
	}
}

if(!function_exists('coursector_limit_get_excerpt'))
{
	function coursector_limit_get_excerpt($excerpt = '', $limit = 50, $string = '...')
	{
		$excerpt = preg_replace(" ([.*?])",'',$excerpt);
		$excerpt = strip_shortcodes($excerpt);
		$excerpt = strip_tags($excerpt);
		$excerpt = substr($excerpt, 0, $limit);
		$excerpt = substr($excerpt, 0, strripos($excerpt, " "));
		$excerpt = $excerpt.$string;
		
		return '<p>'.$excerpt.'</p>';
	}
}

if(!function_exists('coursector_get_image_id'))
{
	function coursector_get_image_id($url) 
	{
		$attachment_id = attachment_url_to_postid($url);
		
		if(!empty($attachment_id))
		{
			return $attachment_id;
		}
		else
		{
			return $url;
		}
	}
}
 
function coursector_attachment_field_credit ($form_fields, $post) {
	$form_fields['coursector-purchase-url'] = array(
		'label' => esc_html__('Purchase URL', 'coursector-elementor'),
		'input' => 'text',
		'value' => esc_url(get_post_meta( $post->ID, 'coursector_purchase_url', true )),
	);

	return $form_fields;
}

add_filter( 'attachment_fields_to_edit', 'coursector_attachment_field_credit', 10, 2 );

function coursector_attachment_field_credit_save ($post, $attachment) {
	if( isset( $attachment['coursector-purchase-url'] ) )
update_post_meta( $post['ID'], 'coursector_purchase_url', esc_url( $attachment['coursector-purchase-url'] ) );

	return $post;
}

add_filter( 'attachment_fields_to_save', 'coursector_attachment_field_credit_save', 10, 2 );
?>