<?php
/**
 * Template Style Two for Call to Action
 *
 * @package Radiantthemes
 */

$output  = '<div class="rt-call-to-action-wraper element-' . esc_attr( $settings['calltoaction_style'] ) . ' ' . $rt_animation . ' ' . esc_attr( $settings['extra_class'] ) . '" ' . $cta_id . ' ' . $time . '>';
$output .= '<div class="rt-call-to-action-wraper-overlay"></div>';
$output .= '<div class="row rt-call-to-action">';
$output .= '<div class="col-lg-8 col-md-7 col-sm-7 col-xs-12">';
$output .= '<div class="rt-call-to-action-item matchHeight text-' . esc_attr( $settings['calltoaction_title_align'] ) . '">';
$output .= '<div class="table">';
$output .= '<div class="table-cell">';
if ( ! empty( $settings['calltoaction_title'] ) ) {
	$output .= '<h3>' . esc_attr( $settings['calltoaction_title'] ) . '</h3>';
}
if ( ! empty( $settings['calltoaction_content'] ) ) {
	$output .= '<p>' . wp_kses_post( $settings['calltoaction_content'] ) . '</p>';
}
$output .= '</div>';
$output .= '</div>';
$output .= '</div>';
$output .= '</div>';
$output .= '<div class="col-lg-4 col-md-5 col-sm-5 col-xs-12">';
$output .= '<div class="rt-call-to-action-item rt-call-to-action-wraper-overlay matchHeight text-' . esc_attr( $settings['calltoaction_subtitle_align'] ) . '">';
$output .= '<div class="table">';
$output .= '<div class="table-cell">';
if ( ! empty( $settings['calltoaction_subtitle'] ) ) {
	$output .= '<h4>' . wp_kses_post( $settings['calltoaction_subtitle'] ) . '</h4>';
}
// CTA Button.
if ( ! empty( $settings['calltoaction_button_title'] ) ) {
	$target     = $settings['calltoaction_button_link']['is_external'] ? ' target="_blank"' : '';
	$nofollow   = $settings['calltoaction_button_link']['nofollow'] ? ' rel="nofollow"' : '';
	$button_url = $settings['calltoaction_button_link']['url'];

	$output .= '<a class="btn" href="' . esc_url( $button_url ) . '"' . $target . $nofollow . '>';
	$output .= esc_html( $settings['calltoaction_button_title'] );
	$output .= '</a>';
}
$output .= '</div>';
$output .= '</div>';
$output .= '</div>';
$output .= '</div>';
$output .= '</div>';
$output .= '</div>';