<?php

/**
 * Typekit
 */

$priority = 0;

Kirki::add_field( 'themegoods_customize', array(
    'type' => 'title',
    'settings'  => 'tg_typekit_title',
    'label'    => esc_html__('Typekit Settings', 'coursector' ),
    'section'  => 'general_fonts',
	'priority' => 0,
) );


Kirki::add_field( 'themegoods_customize', array(
    'type' => 'switch',
    'settings' => 'tg_enable_typekit',
    'label' => esc_html__( 'Enable Typekit', 'coursector' ) ,
    'section' => 'general_fonts',
    'default' => 0,
    'priority' => $priority,
    'transport' => 'auto',
    'choices' => array(
        'on'  => esc_html__( 'Enable', 'coursector' ),
        'off' => esc_html__( 'Disable', 'coursector' )
    )
) );

Kirki::add_field( 'themegoods_customize', array(
    'type' => 'text',
    'settings' => 'tg_typekit_id',
    'label' => esc_html__( 'Typekit ID', 'coursector' ) ,
    'section' => 'general_fonts',
    'default' => '',
    'priority' => $priority,
    'transport' => 'auto',
    'required' => array(
        array(
            'setting' => 'tg_enable_typekit',
            'operator' => '==',
            'value' => '1',
        )
    ) ,
) );

Kirki::add_field( 'themegoods_customize', array(
    'type' => 'repeater',
    'label' => esc_html__( 'Typekit Fonts', 'coursector' ) ,
    'description' => esc_html__( 'Here you can add typekit fonts', 'coursector' ) ,
    'settings' => 'tg_typekit_fonts',
    'priority' => $priority,
    'transport' => 'auto',
    'section' => 'general_fonts',
    'row_label' => array(
        'type' => 'text',
        'value' => esc_html__( 'Typekit Font', 'coursector' ) ,
    ),
    'default' => array(
        array(
            'font_name' => 'Europa',
            'font_css_name' => 'europa-web',
            'font_variants' => array( 'regular', 'italic', '700', '700italic' ),
            'font_fallback' => 'sans-serif',
            'font_subsets' => 'latin'
        )
    ),
    'fields' => array(
        'font_name' => array(
            'type' => 'text',
            'label' => esc_html__( 'Name', 'coursector' ) ,
        ) ,
        'font_css_name' => array(
            'type' => 'text',
            'label' => esc_html__( 'CSS Name', 'coursector' ) ,
        ) ,
        'font_variants' => array(
            'type' => 'select',
            'label' => esc_html__( 'Variants', 'coursector' ) ,
            'multiple' => 18,
            'choices' => array(
                '100' => esc_html__( '100', 'coursector' ) ,
                '100italic' => esc_html__( '100italic', 'coursector' ) ,
                '200' => esc_html__( '200', 'coursector' ) ,
                '200italic' => esc_html__( '200italic', 'coursector' ) ,
                '300' => esc_html__( '300', 'coursector' ) ,
                '300italic' => esc_html__( '300italic', 'coursector' ) ,
                'regular' => esc_html__( 'regular', 'coursector' ) ,
                'italic' => esc_html__( 'italic', 'coursector' ) ,
                '500' => esc_html__( '500', 'coursector' ) ,
                '500italic' => esc_html__( '500italic', 'coursector' ) ,
                '600' => esc_html__( '600', 'coursector' ) ,
                '600italic' => esc_html__( '600italic', 'coursector' ) ,
                '700' => esc_html__( '700', 'coursector' ) ,
                '700italic' => esc_html__( '700italic', 'coursector' ) ,
                '800' => esc_html__( '800', 'coursector' ) ,
                '800italic' => esc_html__( '800italic', 'coursector' ) ,
                '900' => esc_html__( '900', 'coursector' ) ,
                '900italic' => esc_html__( '900italic', 'coursector' ) ,
            )
        ),
        'font_fallback' => array(
            'type' => 'select',
            'label' => esc_html__( 'Fallback', 'coursector' ) ,
            'choices' => array(
                'sans-serif' => esc_html__( 'Helvetica, Arial, sans-serif', 'coursector' ) ,
                'serif' => esc_html__( 'Georgia, serif', 'coursector' ) ,
                'display' => esc_html__( '"Comic Sans MS", cursive, sans-serif', 'coursector' ) ,
                'handwriting' => esc_html__( '"Comic Sans MS", cursive, sans-serif', 'coursector' ) ,
                'monospace' => esc_html__( '"Lucida Console", Monaco, monospace', 'coursector' ) ,
            )
        ) ,
        'font_subsets' => array(
            'type' => 'select',
            'label' => esc_html__( 'Subsets', 'coursector' ) ,
            'multiple' => 7,
            'choices' => array(
                'cyrillic' => esc_html__( 'Cyrillic', 'coursector' ) ,
                'cyrillic-ext' => esc_html__( 'Cyrillic Extended', 'coursector' ) ,
                'devanagari' => esc_html__( 'Devanagari', 'coursector' ) ,
                'greek' => esc_html__( 'Greek', 'coursector' ) ,
                'greek-ext' => esc_html__( 'Greek Extended', 'coursector' ) ,
                'khmer' => esc_html__( 'Khmer', 'coursector' ) ,
                'latin' => esc_html__( 'Latin', 'coursector' ) ,
            )
        ) ,
    ) ,
    'active_callback' => array(
        array(
            'setting' => 'tg_enable_typekit',
            'operator' => '==',
            'value' => '1'
        )
    )
) );