<?php
/*
 *  Setup main navigation menu
 */
add_action( 'init', 'register_my_menu' );
function register_my_menu() {
	register_nav_menu( 'primary-menu', esc_html__('Primary Menu', 'coursector' ) );
	
	if(COURSECTOR_THEMEDEMO)
	{
		register_nav_menu( 'demo-primary-menu', esc_html__('Demo Primary Menu', 'coursector' ) );
	}
	
	register_nav_menu( 'secondary-menu', esc_html__('Secondary Menu', 'coursector' ) );
	register_nav_menu( 'top-menu', esc_html__('Top Bar Menu', 'coursector' ) );
	register_nav_menu( 'side-menu', esc_html__('Side (Mobile) Menu', 'coursector' ) );
	register_nav_menu( 'footer-menu', esc_html__('Footer Menu', 'coursector' ) );
}

class Coursector_Walker extends Walker_Nav_Menu {

	function display_element($element, &$children_elements, $max_depth, $depth=0, $args, &$output) {
        $id_field = $this->db_fields['id'];
        if (!empty($children_elements[$element->$id_field])) { 
            $element->classes[] = 'arrow'; //enter any classname you like here!
        }
        
        Walker_Nav_Menu::display_element($element, $children_elements, $max_depth, $depth, $args, $output);
    }
    
    function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0) {
	    $object = $item->object;
    	$type = $item->type;
    	$title = $item->title;
    	$description = $item->description;
    	$permalink = $item->url;
    	$megamenu = get_post_meta( $item->ID, 'menu-item-megamenu', true );
    	
    	//If globally disable mega menu then remove
    	if(!COURSECTOR_MEGAMENU)
    	{
	    	$megamenu = '';
    	}
    	
	    $output .= "<li class='" .  implode(" ", $item->classes);
	    
	    if($depth == 0 && !empty($megamenu))
	    {
		    $output .= " elementor_megamenu megamenu arrow";
		}
		
		$output .= "'>";
	    
	    $output .= '<a href="' . $permalink . '">';   
	    $output .= $title;
		$output .= '</a>';
		
		if($depth == 0 && !empty($megamenu) && COURSECTOR_MEGAMENU)
	    {
		    if(!empty($megamenu) && class_exists("\\Elementor\\Plugin"))
			{
		    	$output .= '<ul class="elementor_megamenu_wrapper"> '.coursector_get_elementor_content($megamenu).'</ul>';
		    }
		}
	}
}
?>